﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;

namespace CashierCrisis.Graphs
{
    public static class PathPlanner
    {
        public static SparseGraph<PathNode, GraphEdge> Graph { get; set; }
        public static AStarGraphSearch<PathNode, GraphEdge> AStar;
       
        public static List<Vector2> CreatePathToPosition(Vector2 startPosition, Vector2 targetPosition)
        {
            PathNode start = GetClosestNode(startPosition);
            PathNode end = GetClosestNode(targetPosition);

            AStar = new AStarGraphSearch<PathNode, GraphEdge>(Graph, start.Index, end.Index, new HeuristicEuclid());

            List<int> path = AStar.PathToTarget();
            List<Vector2> vPath = new List<Vector2>();
            for (int i = 0; i < path.Count; i++)
            {
                vPath.Add(Graph.GetNode(path[i]).Position);
            }
            return vPath;
        }

        public static PathNode GetClosestNode(Vector2 position)
        {
            PathNode closest = Graph.Nodes[0];
            float distance = 10000f;

            for (int i = 0; i < Graph.NodeCount; i++)
            {
                if ((Vector2.Distance(Graph.Nodes[i].Position, position) < distance) && Graph.Nodes[i].Index != GraphNode.InvalidNodeIndex)
                {
                    closest = Graph.Nodes[i];

                    distance = Vector2.Distance(Graph.Nodes[i].Position, position);
                }
            }
            return closest;
        }
    }
}
